images.cursor = LoadImage("navigation_cursor.png");
images.uparrow = LoadImage("navigation_uparrow.png");
images.downarrow = LoadImage("navigation_downarrow.png");

function menuItem(text, link, description, icon)
{
	this.text = text;
	this.link = link;
	this.description = description;
	if (icon != undefined)
	{
		this.icon = LoadImage(icon + ".png");
	}
	else
		this.icon = undefined;
	this.enabled = true;
}

menuItem.prototype.draw = function(x, y)
{
	if (this.icon != undefined)
	{
		this.icon.blit(x, y);
		font.drawText(x + this.icon.width + 2, y, this.text);
	}
	else
	{
		font.drawText(x, y, this.text);
	}
}

function menuObject()
{
	this.items = new Array(); // All items
	this.selection = new Object();
	this.selection.row = 0;
	this.selection.col = 0;
	this.selection.top = 0;
	this.heading = "COMMAND";
	this.cols = 1;
}

menuObject.prototype.addItem = function(text, link, description, icon, cost)
{
	this.items[this.items.length] = new menuItem(text, link, description);
}

menuObject.prototype.draw = function(x, y, rows)
{
	window.drawWindow(x, y, this.cols * 72 + (this.cols - 1) * 8 + 10, rows * 12, this.heading, this.items[this.getSelection()].description);
	var i = this.selection.top * this.cols;
	for (var irow = 0; irow < rows; irow ++)
	{
		for (var icol = 0; icol < this.cols; icol ++)
		{
			if (i == this.items.length)
			{
				break;
			}
			this.items[i].draw(x + 8 + icol * 80, y + irow * 12);
			i ++;
		}
	}
	// Draw cursor
	drawCursor(x + 8 + this.selection.col * 80, y + (this.selection.row - this.selection.top) * 12);
	// Draw up and/or down arrows
	if (this.selection.top > 0)
	{
		images.uparrow.blit(x + 16 + 72 * this.cols + (this.cols - 1) * 8, y + (rows * 12 / 2) - images.uparrow.height + 2);
	}
	if (this.selection.top + rows < this.items.length / this.cols)
	{
		images.downarrow.blit(x + 16 + 72 * this.cols + (this.cols - 1) * 8, y + (rows * 12 / 2) - 2);
	}
}

menuObject.prototype.control = function(x, y, rows)
{
	if (IsPress() && !IsKeyPressed(KEY_SHIFT))
	{
		if (IsKeyPressed(KEY_UP))
		{
			// Move selection up
			Press();
			if (this.selection.row > 0)
			{
				this.selection.row --;
				if (this.selection.top > this.selection.row)
				{
					this.selection.top --;
				}
			}
		}
		else if (IsKeyPressed(KEY_DOWN))
		{
			// Move selection down
			Press();
			if (this.selection.row < this.items.length / this.cols - 1 && (this.selection.row + 1) * this.cols + this.selection.col < this.items.length)
			{
				this.selection.row ++;
			}
			else if ((this.selection.row + 1) * this.cols < this.items.length)
			{
				this.selection.row ++;
				this.selection.col = 0;
			}
			if (this.selection.row >= this.selection.top + rows)
			{
				this.selection.top ++;
			}
		}
		else if (IsKeyPressed(KEY_LEFT))
		{
			// Move selection left
			if (this.selection.col > 0)
			{
				this.selection.col --;
			}
			Press();
		}
		else if (IsKeyPressed(KEY_RIGHT))
		{
			// Move selection right
			if (this.cols > 1 && this.selection.row * this.cols + this.selection.col + 1 < this.items.length)
			{
				if (this.selection.col < this.cols - 1)
				{
					this.selection.col ++;
				}
			}
			Press();
		}
		if (IsKeyPressed(system.accept))
		{
			var item = this.items[(this.selection.row - this.selection.top) * this.cols + this.selection.col];
			if (item.enabled)
			{
				Press();
				switch (typeof item.link)
				{
					case "string":
						eval(item.link);
						break;
					case "function":
						item.link(this.getSelection(rows));
						break;
					case "undefined":
						return this.getSelection(rows);
						break;
				}
			}
			else
			{
				Press("error");
			}
		}
		else if (IsKeyPressed(system.cancel))
		{
		}
	}
}

menuObject.prototype.execute = function(x, y, rows)
{
	this.draw(x, y, rows);
	return this.control(x, y, rows);
}

menuObject.prototype.getSelection = function()
{
	return this.selection.row * this.cols + this.selection.col;
}